# WP Discourse Shortcodes

The WP Discourse Shortcodes plugin provides a few shortcodes for displaying Discourse content on your WordPress site. It currently has the following shortcodes:

- `discourse_topics` - displays a Discourse topic list

- `discourse_groups` - displays a selection of Discourse groups

- `discourse_user` - displays a Discourse user

- `discourse_users` - displays a list of Discourse users

- `discourse_link`   - creates a link to your Discourse forum

## Shortcode Attributes

### [discourse_link]

| Parameter  | Type | Default | Description |
| ------------- | ---- | ---- | ----- |
| `sso` | boolean | `false` | this will generate a SSO link if set to `true` and SSO is enabled.
| `link_text` | string | `Visit our Forum` | the anchor text.
| `path` | string | (empty) | The path, eg. the value `/foo` will generate `https://forum.example.com/foo`.
| `classes` | string | (empty) | Classes to add to the anchor HTML.

### [discourse_groups]

| Parameter  | Type | Default | Description |
| ------------- | ---- | ---- | ----- |
| `show_description` | boolean | `true` | Whether to show the description.
| `show_images` | boolean | `true` | Whether to show images.
| `excerpt_length` | integer | 55 | The excerpt length.
| `show_header_metadata` | boolean | `true' | Whether to show the metadata (flair, amount of users).
| `tile` | boolean | `false` | Whether to show the groups in a tiled view.
| `sso` | boolean | `false` | this will generate a SSO link if set to `true` and SSO is enabled.
| `group_list` | string || Comma separated list of group names to include. If empty then all public, non-automatic groups will be used.
| `show_join_link` | boolean | `true' |
| `add_button_styles` | boolean | `true` | Adds the `wpds-button` class to the join link.
| `link_open_text` | string | `Join the` | Text to show in the join link before the group name.
| `link_close_text` | string || Text to show in the join link afterthe group name.
| `id` | string | | the shortcode's ID. The HTML that's generated by the shortcodes is cached. If you have more than one 'discourse_groups' shortcode on your site, and the shortcodes are unique, you need to give each 'discourse_groups' shortcode a unique id. Any string will work for the ID. Numbering them is probably the most sensible approach. Defaults to 'null'.

### [discourse_topics]

| Parameter  | Type | Default | Description |
| ------------- | ---- | ---- | ----- |
| `source` | string | `latest` | Can be 'latest', 'filter' or 'top'.
| `period` | string | `all` | if 'top' is the source, gives the period for which you would like the top topics. The options are 'all', 'yearly', 'quarterly', 'monthly', 'weekly', 'daily'.
| `q`      | string | | if 'filter' is the source, this is the filter passed to the topic list filter. Requires Settings - Developer - `experimental topics filter` to be enabled. Documentation [here](https://meta.discourse.org/t/experimental-topics-list-filter-feature/263641).
| `max_topics` | integer | `6` | The maximum number of topics to show.
| `category` | integer or string | | The category slug or id to filter topics by.
| `username_position` | string | `top` | Position for the username. Can be 'top', 'bottom' or 'none'.
| `category_position` | string | `top` | Position for the category name. Can be 'top', 'bottom' or 'none'.
| `date_position` | string | `top` | Position for the date. Can be 'top', 'bottom' or 'none'.
| `display_avatars` | boolean | `true` | Whether to show avatars.
| `tile` | boolean | false |  Adds a `wpds-tile` class to the Discourse topic list item. If the default styles are enabled, it will create a basic flexbox tile display for the topics.
| `excerpt_length` | integer or `full` | | Set to either the number of words you would like in the excerpt, or to 'full' to display the full topic. Leave empty to omit the excerpt.
| `cache_duration` | integer | 10 | how long in minutes to cache the topics. Overridden for the 'latest' route if a webhook is enabled.
| `ajax_timeout` | integer |2 | Ajax load period in minutes. If you've enabled the Ajax Load option on the plugin's options page, this sets the period with which topics will be refreshed.
| `class` | string | | Extra HTML classes to be added to the topic list HTML code.

### [discourse_user]

| Parameter  | Type | Default | Description |
| ------------- | ---- | ---- | ----- |
| `user` | string | `system` | Discourse username.
| `avatar_size` | integer | 120 | Avatar size in pixels.
| `show_name` | boolean | `true` | Show the users name.
| `show_username` | boolean | `true` | Show the users username.

### [discourse_users]

All ``discourse_user`` parameters also work with `discourse_users`.

| Parameter  | Type | Default | Description |
| ------------- | ---- | ---- | ----- |
| `period` | string | `weekly` | User list period.
| `group` | string | | Filters user list by group name.
| `exclude_usernames` | string | | Excludes users from user list by username.
| `order` | string | | Order of user list. Can be likes_received, likes_given, topics_entered, days_visited, posts_read, topic_count, post_count
| `asc` | boolean | | Return user list in ascending order.
| `name` | string | | Filter user list by user name.
| `username` | string | | Filter user list by user username.
| `user_field_ids` | string | | Filter user list by user field ids.
| `plugin_column_ids` | string | | Filter user list by plugin column ids.
| `page` | integer | | Return page of user list.

## Installation

At this moment you will need to `git clone` this repository into your `wp-content/plugins` directory.

## Known bugs and issues

* The plugin is not included in the Wordpress Plugin Directory yet.
